<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Ticket;
use App\Order;
use App\Transaction;
use App\Http\Requests;
use App\Http\Requests\Ticket\StoreRequest;
use App\Http\Requests\Ticket\UpdateRequest;
use Illuminate\Support\Facades\DB;
use Sentinel;
use App\User;

class TicketController extends Controller
{
    public function index()
    {
        $tickets = Ticket::all();
        return view('customers.ticket.ticket_home', compact('tickets'));
    }

    public function update(Request $request, $id)
    {
        $orders = Order::find($id);

//        $this -> validate($request, [
//           'images' => 'mime: jpg, jpeg, png | max:2024',
//        ]);

        if ($request->file('images') == "")
        {
            $orders->images = $orders->images;
            return redirect('data_order')->with('alert-success', 'Resi pembayaran belum diupload');
        }
        else{
            $file       = $request->file('images');
            $fileName   = $file->getClientOriginalName();
            $request->file('images')->move("image/", $fileName);
            $orders->images = $fileName;
            $orders->update();
            return redirect('data_order')->with('alert-success', 'Resi pembayaran berhasil diunggah. Silahkan menunggu konfirmasi pembayaran anda');
        }

    }

    public function destroy($id)
    {
        $tickets = Ticket::findOrFail($id);
        $tickets->delete();
        return redirect()->route('ticket.index')->with('alert-success', 'Data Berhasil Dihapus.');
    }


    public function beli($id){
        $this->data['title'] = "Order";
        $this->data['tickets'] = Ticket::find($id);
        $tickets = DB::table('tickets')->where('id' , $id)->first();
        if($tickets->name==''){
            return redirect(url('/ticket'));
        }else{
            return view('customers.ticket.beli.index',$this->data);
        }
        $orders->save();
    }

    public function storeorder(Request $request)
    {
        $orders = new Order();

        $orders->user_id = $request->user_id;
        $orders->first_name = $request->first_name;
        $orders->nama = $request->nama_ticket;
        $orders->tanggal_kunjung = $request->tanggal_kunjung;
        $orders->jumlah = $request->jumlah;
        $jumlah = $request->jumlah;
        $harga = $request->harga;
        $total = $harga * $jumlah;
        $orders->harga = $total;
        $orders->save();
        return redirect()->route('ticket.index')->with('alert-success', 'Ticket Success Ordered.
                                                        Please pay by transfer bank to 111-111-111 (ABC Bank).
                                                        Then, upload it in Data Pemesanan ');
    }

    public function destroyorder($id)
    {
        $orders = Order::findOrFail($id);
        $orders->delete();
        return redirect()->back();
    }

    public function lunas($id){
        DB::table('orders')->where('id' , $id)->update(['status' => 1]);
        $input = DB::table('orders')->where('id' , $id)->first();
        $trans = new Transaction();
        $trans->id_order = $input->id;
        $trans->id_ticket = $input->id_ticket;
        $trans->user_id = $input->user_id;
        $trans->first_name = $input->first_name;
        $trans->nama = $input->nama;
        $trans->tanggal_kunjung = $input->tanggal_kunjung;
        $trans->jumlah = $input->jumlah;
        $trans->harga = $input->harga;
        $trans->status = $input->status;
        $trans->save();
        return redirect()->back()->with('alert_success', 'Berhasil dikonfirmasi');
    }

    public function upload($id)
    {
        $orders = Order::findOrFail($id);
        return view('customers.ticket.upload', compact('orders'));
    }

    public function dataorder()
    {
        $id = Sentinel::getUser()->id;
        $users = DB::table('users')->where('id', $id)->first();
        $id = $users->id;
        $this->data['users'] = User::find($id);

        $orders = DB::table('orders')->where('user_id', $id)->orderBy('id', 'desc')->where('status','=',0)->get();
        return view('customers.ticket.data_order', compact('orders'));
    }

    public function datakonfirmasi()
    {
        $id = Sentinel::getUser()->id;
        $users = DB::table('users')->where('id', $id)->first();
        $id = $users->id;
        $this->data['users'] = User::find($id);

        $transactions = DB::table('transactions')->where('user_id', $id)->orderBy('id', 'desc')->get();
        return view('customers.ticket.data_konfirmasi', compact('transactions'));
    }

    public function datapesanan()
    {
        $orders = DB::table('orders')->orderby(
            'id','desc')->where('status','=',0)->get();
        return view('staffs.data_pemesanan', compact('orders'));
    }

    public function datatransaksi()
    {
        $transactions = DB::table('orders')->orderby(
            'id','desc')->where('status','=',1)->get();
        return view('staffs.data_transaksi', compact('transactions'));
    }

}
