The Definitive Guide to Yii 2.0
===============================

This tutorial is released under the [Terms of Yii Documentation](http://www.yiiframework.com/doc/terms/).

All Rights Reserved.

2014 (c) Yii Software LLC.


Introduction
------------

* [About Yii](intro-yii.md) - What is Yii and what is it good for?
* [Upgrading from Version 1.1](intro-upgrade-from-v1.md)


Getting Started
---------------

* **TBD** [Overview](start-overview.md) - Where should you start from?
* [Starting with Basic App](start-basic.md) - Best for developing a single-tier application by a single person
* [Starting with Advanced App](start-advanced.md) - Best for developing an enterprise application by a team
* [Starting from Scratch](start-scratch.md) - Learning more in-depth details of creating a Yii application step-by-step

Basic Concepts
--------------

* [Object Properties](basic-properties.md)
* [Events](basic-events.md)
* [Behaviors](basic-behaviors.md)
* [Object Configurations](basic-configs.md)
* **TBD** [Class Autoloading](basic-autoloading.md)
* **TBD** [Path Aliases](basic-alias.md)
* **TBD** [Extensions](basic-extensions.md)
* [Service Locator](basic-service-locator.md)
* **TBD** [Dependency Injection Container](basic-di-container.md)


Basic Structure
---------------

* [MVC Overview](structure-mvc.md)
* **TBD** [Entry Scripts](structure-entry-scripts.md)
* **TBD** [Applications](structure-applications.md)
* [Controllers and Actions](structure-controllers.md)
* [Views](structure-views.md)
* [Models](structure-models.md)
* **TBD** [Widgets](structure-widgets.md)
* **TBD** [Modules](structure-modules.md)


Handling Requests
-----------------

* **TBD** [Request Lifecycle](runtime-lifecycle.md)
* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Routing](runtime-routing.md)
* **TBD** [Requests](runtime-requests.md)
* **TBD** [Responses](runtime-responses.md)
* **TBD** [Sessions and Cookies](runtime-sessions-cookies.md)
* [URL Parsing and Generation](runtime-url-handling.md)
* **TBD** [Filtering](runtime-filtering.md)


Collecting Inputs
-----------------

* [Creating Forms](input-forms.md)
* [Input Validation](input-validation.md)
* **TBD** [Uploading Files](input-file-uploading.md)
* **TBD** [Inputs for Multiple Models](input-multiple-models.md)


Presenting Data
---------------

* **TBD** [Data Formatting](output-formatting.md)
* **TBD** [Pagination](output-pagination.md)
* **TBD** [Sorting](output-sorting.md)
* [Data Providers](output-data-providers.md)
* [Data Widgets](output-data-widgets.md)
* [Managing Assets](output-assets.md)


Working with Database
---------------------

* [Data Access Objects](db-dao.md) - Connecting to a database, basic queries, transactions and schema manipulation
* [Query Builder](db-query-builder.md) - Querying the database using a simple abstraction layer
* [Active Record](db-active-record.md) - The active record ORM, retrieving and manipulating records and defining relations
* [Migrations](db-migrations.md)
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Security
--------

* [Authentication](security-authentication.md)
* [Authorization](security-authorization.md)
* [Working with Passwords](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Best Practices](security-best-practices.md)


Caching
-------

* [Overview](caching-overview.md)
* **TBD** [Data Caching](caching-data.md)
* **TBD** [Fragment and Page Caching](caching-fragment.md)
* **TBD** [HTTP Caching](caching-http.md)


RESTful Web Services
--------------------

* [Quick Start](rest-quick-start.md)
* **TBD** [Resources](rest-resources.md)
* **TBD** [Routing](rest-routing.md)
* **TBD** [Data Formatting](rest-data-formatting.md)
* **TBD** [Authentication](rest-authentication.md)
* **TBD** [Rate Limiting](rest-rate-limiting.md)
* **TBD** [Versioning](rest-versioning.md)
* **TBD** [Caching](rest-caching.md)
* **TBD** [Error Handling](rest-error-handling.md)
* **TBD** [Testing](rest-testing.md)


Testing
-------

* [Overview](test-overview.md)
* **TBD** [Unit Tests](test-unit.md)
* **TBD** [Functional Tests](test-functional.md)
* **TBD** [Acceptance Tests](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Extending Yii
-------------

* [Creating Extensions](extend-creating-extensions.md)
* [Customizing Core Code](extend-customizing-core.md)
* [Using 3rd-Party Libraries](extend-using-libs.md)
* **TBD** [Using Yii in 3rd-Party Systems](extend-embedding-in-others.md)
* **TBD** [Using Yii 1.1 and 2.0 Together](extend-using-v1-v2.md)
* [Using Composer](extend-using-composer.md)


Development Tools
-----------------

* [Debug Toolbar and Debugger](tool-debugger.md)
* [Generating Code using Gii](tool-gii.md)
* **TBD** [Generating API Documentation](tool-api-doc.md)


Special Topics
--------------

* [Configuring Web Servers](tutorial-configuring-servers.md)
* [Console Commands](tutorial-console.md)
* [Handling Errors](tutorial-handling-errors.md)
* [Internationalization](tutorial-i18n.md)
* [Logging](tutorial-logging.md)
* **TBD** [Mailing](tutorial-mailing.md)
* [Performance Tuning](tutorial-performance-tuning.md)
* [Template Engines](tutorial-template-engines.md)
* [Theming](tutorial-theming.md)


Widgets
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)



Helpers
-------

* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

