Говоримо «Привіт»
=================

В даному розділі розглянемо як створити нову сторінку з надписом «Привіт». В процесі вирішеня задачі ви створите
[дію контролера](structure-controllers.md) і [представлення](structure-views.md):

* Додаток опрацює запит і передасть управління відповідній дії
* Дія, в свою чергу, відобразить представлення з надписом "Привіт" кінцевому користувачу

З допомогою даного керівництва ви вивчите:

1. Як створити [дію](structure-controllers.md), яка буде відповідати на запити
2. Як створити [представлення](structure-views.md), щоб формувати зміст відповіді
3. Як додаток відправляє запити до [дії](structure-controllers.md).


Створення дії <a name="creating-action"></a>
-------------

Для нашої задачі знадобиться [дія](structure-controllers.md#creating-actions) `say`, котра читає параметр `message` із
запиту і відображає його значення користувачу. Якщо в запиті відсутній параметр `message`, то дія буде відображати «Привіт».

> Інформація: [Дії](structure-controllers.md#creating-actions) можуть бути запущені безпосередньо користувачем і 
  згруповані в [контролери](structure-controllers.md). Результатом виконання дії є відповідь, яку отримує користувач.

Дії оголошуються в [контролерах](structure-controllers.md). Для зручності, ви можете оголосити дію
`say` в уже існуючому контролері `SiteController`, який оголошений у файлі класа `controllers/SiteController.php`:

```php
<?php

namespace app\controllers;

use yii\web\Controller;

class SiteController extends Controller
{
    // ...існуючий код...

    public function actionSay($message = 'Привіт')
    {
        return $this->render('say', ['message' => $message]);
    }
}
```


В наведеному коді дія `say` оголошена як метод `actionSay` в класі `SiteController`.
Yii використовує префікс `action` для того, щоб відрізняти методи-дії і звичайні методи. Назва після префікса `action`
вважається ідентифікатором відповідної дії.

Коли черга доходить до іменування дій, слід розуміти як Yii відноситься до ідентифікаторів дій.
Ідентифікатори дій задаються в нижньому регістрі. Якщо ідентифікатор складається з декількох слів, вони
з’єднуються дефісами, тобто `create-comment`. Імена методів дій отримуються шляхом видалення дефісів з ідентифікатора, 
перетворення першої літери кожного слова у верхній регістр і додавання префікса `action`.
Наприклад, ідентифікатор дії `create-comment` відповідає методу `actionCreateComment`.

Метод дії приймає параметр `$message`, який за замовчуванням дорівнює `"Привіт"` (так само, як ви звикли визначати
значення за замовчуванням для аргументів методу у PHP). Коли додаток отримує запит і визначає, 
що дія `say` відповідає за його опрацювання, параметр наповнюється одноіменним значенням із запиту.
Іншими словами, якщо запит містить параметр `message` із значенням `"До побачення"`, то змінній `$message`
всередині дії буде призначено це значення.


Всередені метода дії, для відображення [представлення](structure-views.md) з ім’ям `say`, використовується метод
[[yii\web\Controller::render()|render()]]. Для того, щоб вивести повідомлення, у представлення передається параметр `message`.
Результат відображення з допомогою `return` передається додатку, котрий віддає його користувачу.


Створення представлення <a name="creating-view"></a>
-----------------------

[Представлення](structure-views.md) є скриптами, які використовуються для формування тіла відповіді. Для нашого
додатку ви створите представлення `say`, яке буде виводити параметр `message`, отриманий із метода дії:

```php
<?php
use yii\helpers\Html;
?>
<?= Html::encode($message) ?>
```

Представлення `say` мусить бути збережено у файлі `views/site/say.php`. Коли метод [[yii\web\Controller::render()|render()]]
викликається в дії, він буде шукати PHP файл з ім’ям виду `views/ControllerID/ActionID/ViewName.php`.

Варто відмітити, що в коді вище параметр `message` [[yii\helpers\Html::encode()|екранується для HTML]] перед відображенням.
Це обов’язково, так як параметр приходить від користувача, котрий може спробувати провести
[XSS атаку](http://uk.wikipedia.org/wiki/%D0%9C%D1%96%D0%B6%D1%81%D0%B0%D0%B9%D1%82%D0%BE%D0%B2%D0%B8%D0%B9_%D1%81%D0%BA%D1%80%D0%B8%D0%BF%D1%82%D1%96%D0%BD%D0%B3),
шляхом вставки небезпечного JavaScript кода.

Ви можете доповнити представлення `say` HTML тегами, текстом або кодом PHP. Фактично, представлення `say` є
простим PHP скриптом, який виконується методом [[yii\web\Controller::render()|render()]]. Зміст, який відображається
скриптом представлення, буде передано додатком користувачу.


Спробуємо <a name="trying-it-out"></a>
---------

Після створення дії і представлення, ви можете перейти на нову сторінку по наступному URL:

```
http://hostname/index.php?r=site/say&message=Привіт+світ
```

![Привіт, світ](images/start-hello-world.png)

Буде відображена сторінка з надписом "Привіт світ". Вона використовує ту ж шапку і футер, що і решта сторінок додатка.

Якщо ви не вкажете параметр `message`, то побичите на сторінці лише «Привіт». Це відбувається тому, що `message` передається
в метод `actionSay()` і значення за замовчуванням — «Привіт».

> Інформація: Нова сторінка використовує ту ж шапку і футер, що і решта сторінок, тому що метод
  [[yii\web\Controller::render()|render()]] автоматично підставляється в результат представлення `say` в, так званий, 
  [макет](structure-views.md#layouts) `views/layouts/main.php`.

Параметр `r` потребує додаткових пояснень. Він пов’язаний з [маршрутом (route)](runtime-routing.md), який являє 
собою унікальний ідентифікатор, який вказує на дію. Його формат `ControllerID/ActionID`. Коли додаток отримує запит, 
він перевіряє цей параметр і, використовуючи `ControllerID`, визначає який контролер слід використовувати для 
опрацювання запиту. Потім, контролер використовує частину `ActionID`, щоб визначити яка дія виконує реальну роботу.
В нашому випадку маршрут `site/say` буде відповідати контролеру `SiteController` і його дії `say`. 
В результаті, для відпрацювання запиту буде викликано метод `SiteController::actionSay()`.

> Інформація: Як і дії, контролери також мають ідентифікатори, котрі однозначно визначають їх в додатку.
  Ідентифікатори контролерів використовують ті ж самі правила, що і ідентифікатори дій. Імена класів
  контролерів отримуються шляхом видалення дефісів з ідентифікатора, перетворення першої літери кожного слова у верхній 
  регістр і додавання в кінець `Controller`. Наприклад, ідентифікатор контролера `post-comment` відповідає
  імені класа контролера `PostCommentController`.


Підсумок <a name="summary"></a>
--------

В даному розділі ви торкнулися теми контролерів і представлень в паттерні MVC. Ви створили дію, як частину контролера,
який опрацьовує запити, і представлення, яке приймає участь у формувані відповіді. В цьому процесі ніяк не була задіяна
модель, так як в ролі даних виступає тільки простий параметр `message`.

Також ви ознайомились із концепцією маршрутизації, котра є сполучною ланкою між запитом користувача і дією контролера.

В наступному розділі ви дізнаєтесь як створювати моделі і добавляти нові сторінки з HTML формами.
