Компоненты приложения
=====================

Приложения являются [сервис локаторами](concept-service-locators.md). Они хранят множество так называемых
*компонентов приложения*, которые предоставляют различные средства для обработки запросов. Например, 
компоненты `urlManager` ответственен за маршрутизацию веб запросов к нужному контроллеру; компонент `db` предоставляет
средства для работы с базой данных; и т. д.

Каждый компонент приложения имеет свой уникальный ID, который позволяет идентифицировать его среди других различных компонентов
в одном и том же приложении. Вы можете получить доступ к компоненту следующим образом:

```php
\Yii::$app->ComponentID
```

Например, вы можете использовать `\Yii::$app->db` для получения [[yii\db\Connection|соединения с БД]],
и `\Yii::$app->cache` для получения доступа к основному компоненту [[yii\caching\Cache|кэша]], зарегистрированному в приложении.

Компонентами приложения могут быть любые объекты. Вы можете зарегистрировать их с помощью  
свойства [[yii\base\Application::components]] в [конфигурации](structure-applications.md#application-configurations) приложения.
Например,

```php
[
    'components' => [
        // регистрация "cache" компонента с помощью имени класса
        'cache' => 'yii\caching\ApcCache',

        // регистрация "db" компонента с помощью массива конфигурации
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=demo',
            'username' => 'root',
            'password' => '',
        ],

        // регистрация "search" компонента с помощью анонимной функции
        'search' => function () {
            return new app\components\SolrService;
        },
    ],
]
```

> Информация: Хотя вы можете зарегистрировать столько компонентов в приложении сколько вам нужно, 
  все таки стоит это делать разумно. Компоненты приложения похожи на глобальные переменные. Использование слишком
  большого количества компонентов приложения может потенциально сделать ваш код сложным для разработки и тестирования.
  В большинстве случаев вы можете просто создать локальный компонент и использовать его при необходимости.


## Встроенные компоненты приложения <a name="core-application-components"></a>

В Yii есть несколько *встроенных* компонентов приложения, с фиксированными ID и конфигурациями по умолчанию. Например,
компонент [[yii\web\Application::request|request]] используется для сбора информации о запросе пользователя и разбора его в
определенный [маршрут](runtime-routing.md); компонент [[yii\base\Application::db|db]] представляет собой соединение с базой данных,
через которое вы можете выполнять запросы. Именно с помощью этих встроенных компонентов Yii приложения могут обработать
запрос пользователя.

Ниже представлен список встроенных компонентов приложения. Вы можете конфигурировать их также как и другие компоненты приложения.
Когда вы конфигурируете встроенный компонент приложения и не указываете класс этого компонента, то значение по умолчанию будет использовано.

* [[yii\web\AssetManager|assetManager]]: используется для управления и опубликования ресурсов приложения. 
  Более детальная информация представлена в разделе [Ресурсы](output-assets.md);
* [[yii\db\Connection|db]]: представляет собой соединение с базой данных, через которое вы можете выполнять запросы.
  Обратите внимание, что когда вы конфигурируете данный компонент, вы должны указать класс компонента также как и остальные
  необходимые параметры, такие как [[yii\db\Connection::dsn]].
  Более детальная информация представлена в разделе [Объекты доступа к данным (DAO)](db-dao.md);
* [[yii\base\Application::errorHandler|errorHandler]]: осуществляет обработку PHP ошибок и исключений.
  Более детальная информация представлена в разделе [Обработка ошибок](runtime-handling-errors.md);
* [[yii\base\Formatter|formatter]]: форматирует данные для отображения их конечному пользователю. Например, число может
  быть отображено с различными разделителями, дата может быть отображена в формате `long`.
  Более детальная информация представлена в разделе [Форматирование данных](output-formatting.md);
* [[yii\i18n\I18N|i18n]]: используется для перевода сообщений и форматирования.
  Более детальная информация представлена в разделе [Интернационализация](tutorial-i18n.md);
* [[yii\log\Dispatcher|log]]: обработка и маршрутизация логов.
  Более детальная информация представлена в разделе [Логирование](runtime-logging.md);
* [[yii\swiftmailer\Mailer|mail]]: предоставляет возможности для составления и рассылки писем.
  Более детальная информация представлена в разделе [Отправка почты](tutorial-mailing.md);
* [[yii\base\Application::response|response]]: представляет собой данные от сервера, которые будет направлены пользователю.
  Более детальная информация представлена в разделе [Ответы](runtime-responses.md);
* [[yii\base\Application::request|request]]: представляет собой запрос, полученный от конечных пользователей.
  Более детальная информация представлена в разделе [Запросы](runtime-requests.md);
* [[yii\web\Session|session]]: информация о сессии. Данный компонент доступен только в [[yii\web\Application|веб приложениях]].
  Более детальная информация представлена в разделе [Сессии и куки](runtime-sessions-cookies.md);
* [[yii\web\UrlManager|urlManager]]: используется для разбора и создания URL.
  Более детальная информация представлена в разделе [Разбор и генерация URL](runtime-url-handling.md);
* [[yii\web\User|user]]: представляет собой информацию аутентифицированного пользователя. 
  Данный компонент доступен только в [[yii\web\Application|веб приложениях]].
  Более детальная информация представлена в разделе [Аутентификация](security-authentication.md);
* [[yii\web\View|view]]: используется для отображения представлений.
  Более детальная информация представлена в разделе [Представления](structure-views.md).
