Yii PHP Framework Version 2
===========================

Thank you for choosing Yii 2 - a modern PHP framework designed for professional Web development.

Yii 2 is a complete rewrite of its previous version Yii 1.1 which is one of the most popular PHP frameworks.
Yii 2 inherits the main spirit behind Yii for being simple, fast and highly extensible.
Yii 2 requires PHP 5.4 and embraces the best practices and protocols found in modern Web application development.


**Yii 2 is not ready for production use yet.** We may make significant changes without prior notices.
We expect to make the first stable release of Yii 2 in the middle of 2014.

If you mainly want to learn Yii with no real project development requirement, we highly recommend
you start with Yii 2 as it will be our main focus for the next few years.

If you have a real project with tight schedule, you should stick to [Yii 1.1](https://github.com/yiisoft/yii)
which is the latest stable release of Yii.


[![Latest Stable Version](https://poser.pugx.org/yiisoft/yii2/v/stable.png)](https://packagist.org/packages/yiisoft/yii2)
[![Total Downloads](https://poser.pugx.org/yiisoft/yii2/downloads.png)](https://packagist.org/packages/yiisoft/yii2)
[![Build Status](https://secure.travis-ci.org/yiisoft/yii2.png)](http://travis-ci.org/yiisoft/yii2)
[![Code Coverage](https://scrutinizer-ci.com/g/yiisoft/yii2/badges/coverage.png?s=31d80f1036099e9d6a3e4d7738f6b000b3c3d10e)](https://scrutinizer-ci.com/g/yiisoft/yii2/)
[![Dependency Status](https://www.versioneye.com/php/yiisoft:yii2/dev-master/badge.png)](https://www.versioneye.com/php/yiisoft:yii2/dev-master)
[![Scrutinizer Quality Score](https://scrutinizer-ci.com/g/yiisoft/yii2/badges/quality-score.png?s=b1074a1ff6d0b214d54fa5ab7abbb90fc092471d)](https://scrutinizer-ci.com/g/yiisoft/yii2/)

DIRECTORY STRUCTURE
-------------------

```
apps/                ready-to-use application templates
    advanced/        a template suitable for building sophisticated Web applications
    basic/           a template suitable for building simple Web applications
    benchmark/       an application demonstrating the performance of Yii
build/               internally used build tools
docs/                documentation
extensions/          extensions
framework/           core framework code
tests/               tests of the core framework code
```


REQUIREMENTS
------------

The minimum requirement by Yii is that your Web server supports PHP 5.4.


DOCUMENTATION
-------------

A draft of the [Definitive Guide](docs/guide/README.md) is available.

API docs and a rendering of the definitive guide are currently
available at http://stuff.cebe.cc/yii2docs/ (updated four times per hour) and at http://www.yiiframework.com/doc-2.0/guide-index.html.

For 1.1 users, you may refer to [Upgrading from Yii 1.1](docs/guide/intro-upgrade-from-v1.md)
to have a general idea of what has changed in 2.0.


HOW TO PARTICIPATE
------------------

**Your participation to Yii 2 development is very welcome!**

You may participate in the following ways:

* [Report issues](https://github.com/yiisoft/yii2/issues)
* [Give us feedback or start a design discussion](http://www.yiiframework.com/forum/index.php/forum/42-design-discussions-for-yii-20/)
* Fix issues, develop features, write/polish documentation
    - Before you start, please adopt an existing issue (labelled with "ready for adoption") or start a new one to avoid duplicated efforts.
    - Please submit a merge request after you finish development.

In order to make it easier we've prepared [special `yii2-dev` Composer package](https://github.com/yiisoft/yii2/blob/master/docs/internals/getting-started.md).

