from flask import Flask, jsonify
from relay import relay as rel
from buzzer import buzzer
from distance_sensor import ping
from servo import servo
from dht11 import dht11
import time
import RPi.GPIO as GPIO

GPIO.setmode(GPIO.BOARD)

app = Flask(__name__)

@app.route('/relay/<pin>/<mode>')
def relay(pin,mode):
        if mode == "on":
            rel.turn_on(int(pin))
        else:
            rel.turn_off(int(pin))
	
	return jsonify({'status':'ok'})

@app.route('/buzzer/<pin>/<beeps>/<beep_time>/<time_between_beep>')
def buzz(pin,beeps,beep_time,time_between_beep):
        buzzer.beep(int(pin), int(beeps), float(beep_time), float(time_between_beep))
	return jsonify({'status':'ok'})

@app.route('/ping/<echo>/<trigger>')
def dist(echo,trigger):
	jarak = ping.distance(int(echo),int(trigger))
	return jsonify({'data':jarak})

@app.route('/servo/<pin>/<angle>')
def servo_run(pin,angle):
	servo.SetAngle(int(pin), int(angle))
	return jsonify({'status':'ok'})

@app.route('/dht11/<pin>')
def dht_run(pin):
	instance = dht11.DHT11(int(pin))
        while True:
            result = instance.read()
            if result.is_valid():
                break
        #data = jsonify({'temperature':result.temperature,'humidity':result.humidity})
        data = jsonify({'data':{'temperature':result.temperature,'humidity':result.humidity}})
        return data

if __name__ == "__main__":
        try:
            app.run(host='0.0.0.0',port=5000,debug=True)
        except KeyboardInterrupt:  # When 'Ctrl+C' is pressed, the child program destroy() will be  executed.
            GPIO.cleanup()
        
    


