<?php
defined('BASEPATH') or exit('No direct script access allowed');

class adminprofile extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
    }
    public function index()
    {
        $this->load->model('adminprofile_model');
        $data['title'] = 'Admin Profile';
        $data['Anggota'] = $this->db->get('users')->result_array();

        $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();

        $data['users'] = $this->adminprofile_model->getAllUser();


        $this->load->view('admin/adminprofile', $data);
    }
    public function utama()
    {
        $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $data['title'] = "Halaman Utama";
        $this->load->view('admin/utama', $data);
    }
    public function hapus($username)
    {
        $this->db->where('username', $username);
        $this->db->delete('users');
        $this->session->set_flashdata('flash', 'dihapus');
        redirect('adminprofile/index');
    }
    public function edit($id)
    {
        $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $data['id'] = $this->db->get_where('users', ['user_id' => $id])->row_array();
        $this->load->model('m_anggota');
        $where = array('user_id' => $id);
        $data['anggota'] = $this->m_anggota->edit_data($where, 'users')->result();
        $this->load->view('admin/edit_profile', $data);
    }
    public function update()
    {
        $this->load->model('m_anggota');
        $id = $this->input->post('id');
        $username = $this->input->post('username');
        $phone = $this->input->post('phone');
        $email = $this->input->post('email');
        $password = $this->input->post('password');
        $alamat = $this->input->post('alamat');
        $kota = $this->input->post('kota');
        // $foto = $this->input->post('foto');

        $data = array(
            'username' => $username,
            'phone' => $phone,
            'email' => $email,
            'password' => $password,
            'alamat' => $alamat,
            'kota' => $kota

            // 'foto' => $nama

        );

        $where = array(
            'user_id' => $id
        );

        $this->m_anggota->update_data($where, $data, 'users');
        $this->session->set_flashdata('edit', 'Dilakukan');
        redirect('adminprofile');
    }
    public function DaftarOrang()
    {
        $this->load->model('m_cari');
        $member['title'] = "Result";
        $member['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $member['Anggota'] = $this->db->get('users')->result_array();
        if ($this->input->post('cariorang')) {
            $member['Anggota'] = $this->m_cari->cariorang();
        }
        $this->load->view('admin/adminprofile', $member);
    }
    public function cari()
    {
        $this->load->model('m_cari');
        $cari = $this->input->post('cari');

        $data['cari'] = $this->m_cari->get_keyword($cari);
        $this->load->view('admin/adminprofile', $data);
    }
    public function tambahkamar()
    {
        $this->form_validation->set_rules('namakamar', 'namakamar', 'required|trim');
        // $this->form_validation->set_rules('tipekamar', 'tipekamar', 'required');
        $this->form_validation->set_rules('nokamar', 'nokamar', 'required');
        // $this->form_validation->set_rules('fotokamar', 'fotokamar', 'required');
        $this->form_validation->set_rules('hargakamar', 'hargakamar', 'required');

        if ($this->form_validation->run() == false) {
            $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
            $data['kamar'] = $this->db->get_where('kamar', ['namakamar' => $this->session->userdata('namakamar')])->row_array();

            $data['title'] = "Tambah kamar";
            $this->load->view('admin/tambahkamar', $data);
        } else {
            $data = [
                'namakamar' => $this->input->post('namakamar', true),
                'tipekamar' => $this->input->post('tipekamar'),
                'nokamar' => $this->input->post('nokamar'),
                // 'fotokamar' => $this->input->post('kota'),
                'hargakamar' => $this->input->post('hargakamar')

            ];

            $this->db->insert('kamar', $data);
            $this->session->set_flashdata('message', '<div class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
              <img src="..." class="rounded mr-2" alt="...">
              <strong class="mr-auto">Mampars Hotel</strong>
              <small class="text-muted">Anda telah berhasil menambahkan kamar</small>
              <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            
          </div>');
            redirect('adminprofile/utama');
        }
    }
    public function lihatkamar()
    {
        $this->load->model('adminprofile_model');
        $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $data['title'] = 'Lihat kamar';
        $data['Kamar'] = $this->db->get('kamar')->result_array();


        $data['users'] = $this->adminprofile_model->getAllKamar();
        $this->load->view('admin/lihatkamar', $data);
    }
    public function daftarkamar()
    {
        $this->load->model('m_cari');
        $member['title'] = "Result";
        $member['users'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $member['user'] = $this->db->get_where('kamar', ['namakamar' => $this->session->userdata('namakamar')])->row_array();
        $member['Kamar'] = $this->db->get('kamar')->result_array();
        if ($this->input->post('carikamar')) {
            $member['Kamar'] = $this->m_cari->carikamar();
        }
        $this->load->view('admin/lihatkamar', $member);
    }
    public function carikamar()
    {
        $this->load->model('m_cari');
        $cari = $this->input->post('carikamar');

        $data['carikamar'] = $this->m_cari->get_keyword($cari);
        $this->load->view('admin/lihatkamar', $data);
    }
    public function hapuskamar($nokamar)
    {

        $this->db->where('nokamar', $nokamar);
        $this->db->delete('kamar');
        $this->session->set_flashdata('flash', 'dihapus');
        redirect('adminprofile/lihatkamar');
    }

    public function uploadgambar()
    {
        $config['upload_path']          = './upload/product/';
        $config['allowed_types']        = 'gif|jpg|png';
        $config['file_name']            = $this->product_id;
        $config['overwrite']            = true;
        $config['max_size']             = 1024; // 1MB
        // $config['max_width']            = 1024;
        // $config['max_height']           = 768;

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('image')) {
            return $this->upload->data("file_name");
        }

        return "NO pICTURE";
    }
    public function editkamar($nokamar)
    {
        $data['user'] = $this->db->get_where('users', ['email' => $this->session->userdata('email')])->row_array();
        $data['nokamar'] = $this->db->get_where('kamar', ['nokamar' => $nokamar])->row_array();
        $this->load->model('m_kamar');
        $where = array('nokamar' => $nokamar);
        $data['kamar'] = $this->m_kamar->edit_data($where, 'kamar')->result();
        $this->load->view('admin/edit_kamar', $data);
    }
    public function updatekamar()
    {
        $this->load->model('m_kamar');
        $nokamar = $this->input->post('nokamar');
        $namakamar = $this->input->post('namakamar');
        $tipekamar = $this->input->post('tipekamar');
        $hargakamar = $this->input->post('hargakamar');
        // $foto = $this->input->post('foto');

        $data = array(
            'namakamar' => $namakamar,
            'tipekamar' => $tipekamar,
            'hargakamar' => $hargakamar

            // 'foto' => $nama

        );

        $where = array(
            'nokamar' => $nokamar
        );

        $this->m_kamar->update_data($where, $data, 'kamar');
        $this->session->set_flashdata('edit', 'Dilakukan');
        redirect('adminprofile/lihatkamar');
    }
}
