@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa-bus"></i>Pesan Bus</li>
                    <li class="active"><i class="fa-bus"></i>Pilih Bus</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box">
                            <div class="box-header">
                                <h3 class="box-title">List Bus</h3>
                                <div class="box-tools">
                                    <form action="{{url('/klien/pesan/pilih')}}">
                                        <div class="input-group input-group-sm" style="width: 150px;">
                                            <input type="text" name="search" class="form-control pull-right"
                                                   placeholder="Nama Bus" id="search" type="text">
                                            <div class="input-group-btn">
                                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body table-responsive no-padding">
                                <table class="table table-hover">
                                    <thead><tr>
                                        <th>Nama Bus</th>
                                        <th>Jenis Bus</th>
                                        <th>Plat Bus</th>
                                        <th>Aksi</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($bus as $bu)
                                        <tr>
                                            <td>{{$bu->nama_bus}}</td>
                                            <td>{{$bu->jenis_bus}}</td>
                                            <td>{{$bu->plat_bus}}</td>
                                            <td colspan="1">
                                                <a href="{{url('klien/bus/detail',$bu->id)}}" class="btn btn-danger">Detail</a>
                                                <a href="{{url('klien/pesan/pilih_bus',$bu->id)}}" class="btn btn-danger">Pilih</a>
                                            </td>
                                        </tr>
                                        </form>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>

                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif