@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="{{url('/')}}"><i class="fa fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa fa-taxi"></i>Pesan Kendaraan</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="box box-default">

                    <form action="{{url('/klien/pemesanan')}}" method="post" enctype="multipart/form-data">
                        {{ csrf_field() }}
                    <div class="box-header with-border">
                        <h3 class="box-title">Formulir Pemesanan Bus</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Nama Pemesan</label>
                                    <input type="text" value="{{ Auth::user()->username }}" class="form-control" name="client_username" readonly>
                                </div>

                                <div class="form-group">
                                    <label>Pilih Kendaraan (Optional)</label>
                                    <input type="text" value=" " class="form-control" name="plat_bus" required>
                                    <span class="input-group-btn">
                                        <a href="{{url('klien/pesan/pilih')}}" type="button" onclick="return confirm('Pilih Bus??')"
                                           class="btn btn-info btn-flat">Pilih Bus</a>
                                    </span>
                                </div>

                                <div class="form-group">
                                    <label>Tempat Tujuan Keberangkatan</label>
                                    <input type="text" class="form-control" name="tujuan" required>
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <label>Jumlah Anggota</label>
                                    <input type="text" class="form-control" name="jumlah" required>
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <label>Keperluan Pemesanan</label>
                                    <textarea class="form-control" rows="3"name="alasan" placeholder="Alasan..." style="width: 499px; height: 104px;" required></textarea>
                                </div>
                                <!-- /.form-group -->
                            </div>
                            <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Rencana Keberangkatan:</label>
                                    <div class="input-group date">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input class="form-control pull-right" id="datepicker" type="text" name="berangkat" required>
                                    </div>
                                    <!-- /.input group -->
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <label>Rencana Kembali:</label>
                                    <div class="input-group date">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input class="form-control pull-right" id="datepicker" type="text" name="kembali" required>
                                    </div>
                                    <!-- /.input group -->
                                </div>
                                <!-- /.form-group -->

                                <div class="form-group">
                                    <input type="hidden" value="request" class="form-control" name="status" readonly>
                                </div>

                                <div class="form-group">
                                </div>
                                <!-- /.form-group -->

                                <!-- /.form-group -->
                                <div class="form-group">
                                    <input type="submit" value="Pesan" class="btn btn-danger">
                                </div>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    </form>
                    <div class="box-footer">* Pemesanan hanya dapat di lakukan 3 hari sebelum hari keberangkatan</div>
                </div>

            </section>
            <!-- /.content -->

        </div>
    </div>
    </body>
@endif