@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="{{url('/')}}"><i class="fa fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa fa-clipboard"></i> Riwayat Pemesanan</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box">
                            <div class="box-header">
                                <h3 class="box-title">List Pemesanan</h3>
                                <div class="box-tools"></div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body table-responsive no-padding">
                                <table class="table table-hover">
                                    <thead><tr>
                                        <th><i class="fa fa-user"></i> Nama Pemesan</th>
                                        <th><i class="fa fa-hand-o-right"></i> Tujuan</th>
                                        <th><i class="fa fa-calendar-plus-o"></i> Tanggal Berangkat</th>
                                        <th><i class="fa fa-check-square-o"></i> Status</th>
                                        <th><i class="fa fa-eye"></i> Lihat</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($history as $his)
                                        <tr>
                                            <td>{{$his->client_username}}</td>
                                            <td>{{$his->tujuan}}</td>
                                            <td>{{$his->berangkat}}</td>
                                            <td><span class="label label-danger">Dibatalkan</span>
                                            <td colspan="1">
                                                <a href="{{url('klien/history/detail',$his->id)}}" class="btn btn-danger">Detail</a>
                                            </td>
                                        </tr>
                                        </form>
                                    @endforeach
                                    @foreach($status as $stat)
                                        <tr>
                                            <td>{{$stat->client_username}}</td>
                                            <td>{{$stat->tujuan}}</td>
                                            <td>{{$stat->berangkat}}</td>
                                            <td><span class="label label-info">{{$stat->status}}</span></td>
                                            <td colspan="1">
                                                <a href="{{url('klien/history/detail2',$stat->id)}}" class="btn btn-danger">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>

                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif