--
-- Database: `pemesanan_bus`
--

-- --------------------------------------------------------

--
-- Struktur dari tabel `batal`
--

CREATE TABLE `batal` (
  `id` int(10) NOT NULL,
  `tujuan` varchar(100) NOT NULL,
  `jumlah` int(100) NOT NULL,
  `alasan` text NOT NULL,
  `berangkat` date NOT NULL,
  `kembali` date NOT NULL,
  `client_username` varchar(100) NOT NULL,
  `plat_bus` varchar(100) NOT NULL,
  `alasan_batal` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `batal`
--

INSERT INTO `batal` (`id`, `tujuan`, `jumlah`, `alasan`, `berangkat`, `kembali`, `client_username`, `plat_bus`, `alasan_batal`, `created_at`, `updated_at`) VALUES
(1, 'Medan', 10, 'Jalan-Jalan', '2016-10-10', '2017-10-10', 'klien', ' ', 'Mau Mati', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(2, 'Medan', 10, 'Mau ke surga', '2016-10-10', '2017-10-10', 'klien', ' ', 'Mau ke surga', '2017-05-08 19:02:07', '2017-05-08 19:02:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `bus`
--

CREATE TABLE `bus` (
  `id` int(10) NOT NULL,
  `nama_bus` varchar(100) NOT NULL,
  `jenis_bus` varchar(100) NOT NULL,
  `plat_bus` varchar(1000) NOT NULL,
  `deskripsi` text NOT NULL,
  `image` varchar(1000) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `bus`
--

INSERT INTO `bus` (`id`, `nama_bus`, `jenis_bus`, `plat_bus`, `deskripsi`, `image`, `created_at`, `updated_at`) VALUES
(1, 'Optimus', 'Autobot', '911', 'Optimus Prime', '1493174984.jpg', '2017-04-24 17:29:05', '2017-04-25 12:49:44'),
(4, 'Bumble Bee', 'Autobot', '912', 'Killer Bee', '1494822927.jpg', '2017-04-27 11:51:47', '2017-05-14 14:35:27'),
(8, 'Perkasa', 'Truck', 'BB 8387 CE', 'Kapasitas 30 orang', '1494836360.jpg', '2017-05-14 18:19:20', '2017-05-14 18:19:20');

-- --------------------------------------------------------

--
-- Struktur dari tabel `jadwal`
--

CREATE TABLE `jadwal` (
  `id` int(100) NOT NULL,
  `hari` varchar(100) NOT NULL,
  `nama_supir` varchar(100) NOT NULL,
  `nama_supir2` varchar(100) NOT NULL,
  `pukul` time NOT NULL,
  `pukul2` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `jadwal`
--

INSERT INTO `jadwal` (`id`, `hari`, `nama_supir`, `nama_supir2`, `pukul`, `pukul2`, `created_at`, `updated_at`) VALUES
(1, 'Senin', 'Supir', 'Supir 2', '06:00:00', '18:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(2, 'Selasa', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-23 07:00:00'),
(3, 'Rabu', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(4, 'Kamis', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(5, 'Jumat', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(6, 'Sabtu', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32'),
(7, 'Minggu', '', '', '00:00:00', '00:00:00', '2017-05-08 13:59:32', '2017-05-08 13:59:32');

-- --------------------------------------------------------

--
-- Struktur dari tabel `konfirmasi`
--

CREATE TABLE `konfirmasi` (
  `id` int(10) NOT NULL,
  `tujuan` varchar(100) NOT NULL,
  `jumlah` int(100) NOT NULL,
  `alasan` text NOT NULL,
  `berangkat` date NOT NULL,
  `kembali` date NOT NULL,
  `client_username` varchar(100) NOT NULL,
  `status` varchar(100) NOT NULL,
  `plat_bus` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `konfirmasi`
--

INSERT INTO `konfirmasi` (`id`, `tujuan`, `jumlah`, `alasan`, `berangkat`, `kembali`, `client_username`, `status`, `plat_bus`, `created_at`, `updated_at`) VALUES
(3, 'Bandung', 20, 'Jalan-Jalan', '2016-10-15', '2017-10-10', 'klien', 'disetujui', ' ', '2017-05-22 02:41:23', '2017-05-22 02:41:23'),
(33, 'ww', 2, 'tryy', '2016-10-10', '2017-10-10', 'klien', 'disetujui', ' ', '2017-05-18 03:10:31', '2017-05-18 03:10:31');

-- --------------------------------------------------------

--
-- Struktur dari tabel `pemesanan`
--

CREATE TABLE `pemesanan` (
  `id` int(10) NOT NULL,
  `tujuan` varchar(100) NOT NULL,
  `jumlah` int(100) NOT NULL,
  `alasan` text NOT NULL,
  `berangkat` date NOT NULL,
  `kembali` date NOT NULL,
  `client_username` varchar(100) NOT NULL,
  `plat_bus` varchar(100) NOT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `pemesanan`
--

INSERT INTO `pemesanan` (`id`, `tujuan`, `jumlah`, `alasan`, `berangkat`, `kembali`, `client_username`, `plat_bus`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Medan', 10, 'ON MIPA', '2016-10-10', '2017-10-10', 'klien', '912', 'diproses', '2017-05-22 02:37:29', '2017-05-22 02:40:10'),
(2, 'Semarang', 10, 'Jalan-Jalan', '2017-05-14', '2017-05-17', 'klien', '911', 'diproses', '2017-05-22 02:38:02', '2017-05-22 02:40:05');

-- --------------------------------------------------------

--
-- Struktur dari tabel `supir`
--

CREATE TABLE `supir` (
  `id` int(10) NOT NULL,
  `nama_supir` varchar(100) NOT NULL,
  `ttl` varchar(100) NOT NULL,
  `alamat` varchar(100) NOT NULL,
  `jk` varchar(100) NOT NULL,
  `agama` varchar(100) NOT NULL,
  `image` varchar(1000) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `supir`
--

INSERT INTO `supir` (`id`, `nama_supir`, `ttl`, `alamat`, `jk`, `agama`, `image`, `created_at`, `updated_at`) VALUES
(123, 'Supir', 'Sitoluama / 09-11-1996', 'Sitoluama', 'Laki-Laki', 'Lain', '1493345735.jpg', '2017-04-27 12:15:35', '2017-04-27 12:39:11'),
(1234, 'Supir 2', 'Sitoluama / 09-11-1996', 'Sitoluama', 'Laki-Laki', 'K.Protestan', '1495427521.jpg', '2017-05-21 21:32:01', '2017-05-21 21:32:01'),
(12345, 'Supir 3', 'Sitoluama / 09-11-1996', 'Sitoluama', 'Laki-Laki', 'K.Protestan', '1495427542.jpg', '2017-05-21 21:32:22', '2017-05-21 21:32:22');

-- --------------------------------------------------------

--
-- Struktur dari tabel `users`
--

CREATE TABLE `users` (
  `id` int(10) UNSIGNED NOT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `role` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data untuk tabel `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `role`, `remember_token`, `created_at`, `updated_at`) VALUES
(2, 'k_klien', '$2y$10$RYpRtEdIeZoAhvhZJqDyUuwPq5t4jQIhRgyx8sUk2h4gKmP60dm.2', 'admin', 'GGIwhAb49IYn3f6wRzrC7URwGQdH1zBJx2Wzf3JZavJxXMYfUgaPsTixHyZM', '2017-04-10 14:30:13', '2017-05-22 23:28:54'),
(4, 'k_supir', '$2y$10$uFVdCb3I5aoQuKX474arD.Jo4KjXCiejs4uMDNzYudRe.FTxdvn8S', 'k_supir', 'IMYQGyZejnP2rrUw56m2WBmRYiW6bahGoyVHybq80OLK3POWtF6wGicwRwEA', '2017-04-18 14:02:08', '2017-05-22 02:36:47'),
(7, 'klien', '$2y$10$YK4Otf.9YAXfxS4LI5MS/uydscvcS0oqIEHAncAodOpFgulK02UFm', 'klien', 'coiJnOEng5lvmU40fjVIg11TUnblMkb86dl02mk13EZmiTYb0hxZloHpaDfk', '2017-04-21 00:39:53', '2017-05-22 02:39:40');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `batal`
--
ALTER TABLE `batal`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `bus`
--
ALTER TABLE `bus`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `jadwal`
--
ALTER TABLE `jadwal`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `konfirmasi`
--
ALTER TABLE `konfirmasi`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `pemesanan`
--
ALTER TABLE `pemesanan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `supir`
--
ALTER TABLE `supir`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_username_unique` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `batal`
--
ALTER TABLE `batal`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `bus`
--
ALTER TABLE `bus`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT for table `jadwal`
--
ALTER TABLE `jadwal`
  MODIFY `id` int(100) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT for table `pemesanan`
--
ALTER TABLE `pemesanan`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
