@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa-users"></i>Bus</li>
                    <li class="active"><i class="fa-users"></i>Ubah Data Bus</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-md-6">
                        <!-- Box Comment -->
                        <div class="box box-widget">
                            <div class="box-header with-border">
                                <div class="user-block">
                                    <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('image/' . $bus->image) }}"/>
                                    <span class="username">{{$bus->nama_bus}}</span>
                                </div>
                                <!-- /.user-block -->
                                <div class="box-tools">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                </div>
                                <!-- /.box-tools -->
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">

                                <div class="col-md-9">
                                    <div class="nav-tabs-custom">
                                        <ul class="nav nav-tabs">
                                            <li class="active"><a href="#gambar1" data-toggle="tab" aria-expanded="true">Gambar1</a></li>
                                            <li class=""><a href="#gambar2" data-toggle="tab" aria-expanded="false">Gambar2</a></li>
                                            <li class=""><a href="#gambar3" data-toggle="tab" aria-expanded="false">Gambar3</a></li>
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="gambar1">
                                                <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('image/' . $bus->image) }}"/>
                                            </div>
                                            <!-- /.tab-pane -->
                                            <div class="tab-pane" id="gambar2">
                                                <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('image/' . $bus->image2) }}"/>
                                            </div>
                                            <!-- /.tab-pane -->
                                            <div class="tab-pane" id="gambar3">
                                                <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('image/' . $bus->image3) }}"/>
                                            </div>
                                            <!-- /.tab-pane -->
                                        </div>
                                        <!-- /.tab-content -->
                                    </div>
                                    <!-- /.nav-tabs-custom -->
                                    <a href="{{url('admin/bus/ubahgambar',$bus->id)}}" class="btn btn-danger">Ubah Gambar</a>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                            <div class="box-footer">
                                <form action="{{url('/admin/ubah',$bus->id)}}" method="post" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="form-group has-feedback">
                                        <label class="col-md-4 control-label">Nama Bus</label>
                                        <input type="text" class="form-control" name="nama_bus" value="{{$bus->nama_bus}}" required>
                                    </div>
                                    <div class="form-group has-feedback">
                                        <label class="col-md-4 control-label">Jenis Bus</label>
                                        <input type="text" class="form-control" name="jenis_bus" value="{{$bus->jenis_bus}}" required>
                                    </div>
                                    <div class="form-group has-feedback">
                                        <label class="col-md-4 control-label">Plat Bus</label>
                                        <input type="text" class="form-control" name="plat_bus" value="{{$bus->plat_bus}}" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Deskripsi</label>
                                        <textarea class="form-control" placeholder="Berikan deskripsi disini" rows="3" name="deskripsi" required>{{$bus->deskripsi}}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <input type="submit" value="Ubah Bus" class="btn btn-danger">
                                    </div>
                                </form><br>
                            </div>
                            <!-- /.box-footer -->
                        </div>
                        <!-- /.box -->
                    </div>
                    <!-- /.col -->
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif